// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : |S\vO[ CSceneModel.h ]	Auter : KENSUKE WATANABE
//													Data  : 2016/05/30
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2016/05/30
//
// ======== ======== ======== ======== ======== ======== ======== ========
#ifndef _CSCENEMODEL_H_
#define _CSCENEMODEL_H_

#include "main.h"
#include <string>
#include "scene.h"

// -------- -------- -------- -------- -------- -------- -------- --------
// NX
// -------- -------- -------- -------- -------- -------- -------- --------
class CSceneModel : public CScene
{
public:
	CSceneModel(int priority = 4) :CScene(priority), m_pParent(nullptr) { m_classType = CLASSTYPE::SCENE_MODEL; }
	~CSceneModel() {}

	void Init(void);
	void Uninit(void);
	void Update(void);
	void Draw(void);

	// ݒ
	void SetBasePos(const D3DXVECTOR3 &pos) { m_basePos = pos; }
	void SetBaseRot(const D3DXVECTOR3 &rot) { m_baseRot = rot; }
	void SetSize(const D3DXVECTOR3 &size) { m_size = size; }
	void SetParent(CSceneModel *pParent) { m_pParent = pParent; }
	void SetFilePass(std::string strFilePass){ m_strFilePass = strFilePass; }

	// 擾
	std::string GetFilePath(void)const { return m_strFilePass; }
	std::string GetPartsName(void)const { return m_strPartsName; }

	// }gNXݒ֐
	D3DXMATRIX GetMatrixRot(CSceneModel *pParent);
	D3DXMATRIX GetMatrixPos(CSceneModel *pParent); 
	D3DXMATRIX GetMatrixWorld(CSceneModel *pParts);

	static CSceneModel* Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &scl, const std::string &strFilePass);
	static CSceneModel* Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &scl, const std::string &strFilePass, std::string strPartsName);
	static CSceneModel* GetParts(std::string partsName); 		// Parts̎擾
	static CSceneModel* GetParent(CSceneModel *parts);			// eParts̎擾

	// f
	void CreateModel(std::string strFilePass);

protected:
	std::string m_strFilePass;		// eNX`FilePass
	std::string m_strPartsName;

	D3DXMATRIX m_mtxWorld;			// [h}gNX
	D3DXMATRIX m_mtxRot;			// 
	D3DXMATRIX m_mtxPos;			// 
	D3DXMATRIX m_mtxScl;			// 
	D3DXVECTOR3 m_basePos;			// W
	D3DXVECTOR3 m_baseRot;			// ]

	CSceneModel* m_pParent;			// ep[c̃|C^
	D3DXVECTOR3 m_size;				// ,,s

};

#endif
